
byte getMinComponent(ColorBgra color){
	return Math.Min( Math.Min(color.R, color.G), color.B );
}

ColorBgra removeWhite(ColorBgra color){
	ColorBgra result = new ColorBgra();
	
	byte minComponent;
	minComponent = getMinComponent(color);

	if( minComponent == 0 ){
		result.A = (byte)color.A;
		result.R = (byte)color.R;
		result.G = (byte)color.G;
		result.B = (byte)color.B;
	}else{
		double transparencyParameter;
		transparencyParameter = 1.0 - (double)minComponent / 255.0;

		result.A = (byte)(255.0 * transparencyParameter * (color.A / 255.0));
		result.R = (byte)((color.R - minComponent) / transparencyParameter);
		result.G = (byte)((color.G - minComponent) / transparencyParameter);
		result.B = (byte)((color.B - minComponent) / transparencyParameter);
	}

	return result;
}

void Render(Surface dst, Surface src, Rectangle rect){
	ColorBgra currentPixel;

	for (int y = rect.Top; y < rect.Bottom; y++){
		for (int x = rect.Left; x < rect.Right; x++){
			currentPixel = src[x,y];
			dst[x,y] = removeWhite(currentPixel);
		}
	}
}
